//
//  FlipsideViewController.m
//  AppSettings
//
//  Created by Robert Górczyński on 11-07-12.
//

#import "FlipsideViewController.h"
#import "MainViewController.h"


@implementation FlipsideViewController

@synthesize delegate;
@synthesize engineSwitch; 
@synthesize warpFactorSlider; 

- (void)applicationWillEnterForeground:(NSNotification *)notification { 
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults]; 
    [defaults synchronize]; 
    [self refreshFields]; 
}

- (void)viewDidLoad {
    [super viewDidLoad];
    [self refreshFields];      
    UIApplication *app = [UIApplication sharedApplication]; 
    [[NSNotificationCenter defaultCenter] addObserver:self 
											 selector:@selector(applicationWillEnterForeground:) 
												 name:UIApplicationWillEnterForegroundNotification 
											   object:app]; 	
}

- (void)refreshFields { 
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults]; 
    engineSwitch.on = [[defaults objectForKey:kWarpDriveKey] 
					   isEqualToString:@"Engaged"] ? YES : NO; 
    warpFactorSlider.value = [defaults floatForKey:kWarpFactorKey]; 
	
}
- (IBAction)touchEngineSwitch { 
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults]; 
	NSString *prefValue = engineSwitch.on ? @"Engaged" : @"Disabled"; 
	[defaults setObject:prefValue forKey:kWarpDriveKey];
	[defaults synchronize];
} 

- (IBAction)touchWarpSlider { 
	NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults]; 
	[defaults setFloat:warpFactorSlider.value forKey:kWarpFactorKey];
	[defaults synchronize];
} 

- (IBAction)done:(id)sender {
	[self.delegate flipsideViewControllerDidFinish:self];	
}


- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}


- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
	[[NSNotificationCenter defaultCenter] removeObserver:self]; 
	self.engineSwitch = nil; 
    self.warpFactorSlider = nil;
	[super viewDidUnload];
}

- (void)dealloc {
    [engineSwitch release]; 
    [warpFactorSlider release]; 
    [super dealloc];
}


@end
